/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.RogueAp;
import com.tp_link.eap.domain.eapsetting.RogueApConfig;
import com.tp_link.eap.domain.message.body.EapConfigBody;
import com.tp_link.eap.domain.record.SettingRecord;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.i.a.a;
import com.tp_link.eap.monitor.monitor.repo.ApRepository;
import com.tp_link.eap.monitor.monitor.repo.RogueRepository;
import com.tp_link.eap.monitor.monitor.service.i;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.a.f;
import com.tp_link.eap.util.l;
import com.tp_link.eap.util.p.c;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.json.JSONObject;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="rogueService")
public class RogueService
extends a<RogueAp>
implements i {
    @Autowired
    private RogueRepository b;
    @Autowired
    private ApRepository c;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a d;
    Logger a = LoggerFactory.getLogger(this.getClass());
    private static final String e = "trustedAps";
    private static final String f = "Trusted_Ap_List";

    @Override
    public List<RogueAp> getRougeAps() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
    }

    @Override
    public OperationResponse trust(String rogueId) {
        if (rogueId == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        QueryFilter queryFilter = new QueryFilter("isTrusted", (Object)true, QueryFilter.FilterType.eq);
        long l2 = this.count(Collections.singletonList(queryFilter), null);
        if (l2 >= (long)com.tp_link.eap.util.e.bC.intValue()) {
            return new OperationResponse(ResErrorCode.cT);
        }
        RogueAp rogueAp = (RogueAp)this.b.findOne((Serializable)((Object)rogueId));
        if (rogueAp == null) {
            return new OperationResponse(ResErrorCode.cU);
        }
        rogueAp.setTrusted(true);
        this.b.save(rogueAp);
        RogueApConfig rogueApConfig = new RogueApConfig();
        rogueApConfig.setMac(rogueAp.getMac());
        rogueApConfig.setTrust(Boolean.valueOf(true));
        this.a(rogueApConfig);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse trust(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("rogueId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.trust(string);
    }

    @Override
    public OperationResponse unTrust(String rogueId) {
        if (rogueId == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        RogueAp rogueAp = (RogueAp)this.b.findOne((Serializable)((Object)rogueId));
        if (rogueAp == null) {
            return new OperationResponse(ResErrorCode.cY);
        }
        rogueAp.setTrusted(false);
        this.b.save(rogueAp);
        RogueApConfig rogueApConfig = new RogueApConfig();
        rogueApConfig.setMac(rogueAp.getMac());
        rogueApConfig.setTrust(Boolean.valueOf(false));
        this.a(rogueApConfig);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse untrust(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("rogueId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.unTrust(string);
    }

    @Override
    public boolean refreshRogueAps(List<RogueAp> rogueAps) {
        if (rogueAps == null || rogueAps.isEmpty()) {
            return true;
        }
        for (int i2 = 0; i2 < rogueAps.size(); ++i2) {
            RogueAp rogueAp = rogueAps.get(i2);
            RogueAp rogueAp2 = this.b.findByMacAndSite(rogueAp.getMac(), rogueAp.getSite());
            if (rogueAp2 != null) {
                if (com.tp_link.eap.util.a.e.a((String)rogueAp.getSsid()) && rogueAp.isTrusted() && (rogueAp.getChannel() == null || rogueAp.getChannel() == -1)) continue;
                rogueAp.setId(rogueAp2.getId());
                rogueAp.setTrusted(rogueAp2.isTrusted());
            } else if (rogueAp.isTrusted()) continue;
            this.b.save(rogueAp);
        }
        this.a();
        return true;
    }

    @Override
    public RogueAp getSiteRogueByMac(String mac) {
        if (mac == null) {
            return null;
        }
        return this.b.findByMacAndSite(mac, com.tp_link.eap.d.b.a());
    }

    @Override
    public RogueAp getRogue(String rogueId) {
        if (rogueId == null) {
            return null;
        }
        return (RogueAp)this.b.findOne((Serializable)((Object)rogueId));
    }

    public List<RogueAp> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<RogueAp> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<RogueAp> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public List<RogueAp> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null, null);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.countByFilters(filters, searchFilters);
    }

    @Override
    public List<RogueAp> getThreadSiteTrustList() {
        return this.b.findByIsTrustedAndSite(true, com.tp_link.eap.d.b.a());
    }

    @Override
    public void exportTrustList(OutputStream os) {
        boolean bl = false;
        Element element = com.tp_link.eap.util.a.f.b((String)e);
        List<RogueAp> list = this.getThreadSiteTrustList();
        if (list != null && !list.isEmpty()) {
            for (RogueAp rogueAp : list) {
                element.addElement("mac").addText(rogueAp.getMac());
                bl = true;
            }
        }
        if (!bl) {
            element.addElement("mac").addText("00:00:00:00:00:00(Please change it to AP MAC to be trusted.)");
        }
        try {
            RogueAp rogueAp;
            OutputFormat outputFormat = OutputFormat.createPrettyPrint();
            outputFormat.setEncoding("UTF-8");
            outputFormat.setIndent(true);
            outputFormat.setIndent("  ");
            rogueAp = new XMLWriter(os, outputFormat);
            rogueAp.write(element);
            rogueAp.flush();
            rogueAp.close();
        }
        catch (IOException iOException) {
            this.a.warn("exception .", (Throwable)iOException);
        }
    }

    @Override
    public OperationResponse importTrustList(String trustXml, boolean isReplace) {
        if (trustXml == null || trustXml.equals("")) {
            return new OperationResponse(ResErrorCode.di);
        }
        return this.a(trustXml, isReplace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResponse a(String string, boolean bl) {
        String string2 = com.tp_link.eap.d.b.a();
        HashMap<Object, Boolean> hashMap = new HashMap<Object, Boolean>();
        try {
            Object object;
            Object object2;
            Object object32;
            List list;
            Document document = DocumentHelper.parseText((String)string);
            Element element = document.getRootElement();
            if (!this.a(element)) {
                return new OperationResponse(ResErrorCode.di);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (bl && !CollectionUtils.isEmpty((Collection)(list = this.getThreadSiteTrustList()))) {
                for (Object object4 : list) {
                    arrayList.add(object4.getMac());
                }
            }
            list = element.elements("mac");
            ArrayList arrayList2 = new ArrayList();
            if (list != null && !list.isEmpty()) {
                for (Object object32 : list) {
                    String string3 = l.c((String)object32.getText().trim());
                    arrayList2.add(string3);
                }
            }
            if (!arrayList.isEmpty()) {
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    object32 = (String)arrayList.get(i2);
                    boolean bl2 = false;
                    if (!arrayList2.isEmpty()) {
                        for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                            if (!((String)arrayList2.get(i3)).equals(object32)) continue;
                            bl2 = true;
                            arrayList2.remove(i3);
                            hashMap.put(object32, true);
                            break;
                        }
                    }
                    if (!bl2) continue;
                    arrayList.remove(i2);
                    --i2;
                }
            }
            ArrayList<Object> arrayList3 = new ArrayList<Object>();
            if (!arrayList.isEmpty()) {
                for (String string4 : arrayList) {
                    RogueAp rogueAp = this.b.findByMacAndSite(string4, com.tp_link.eap.d.b.a());
                    if (rogueAp == null) continue;
                    this.b.delete(rogueAp);
                    RogueApConfig rogueApConfig = new RogueApConfig();
                    rogueApConfig.setMac(string4);
                    rogueApConfig.setTrust(Boolean.valueOf(false));
                    arrayList3.add(rogueApConfig);
                }
            }
            object32 = new QueryFilter("isTrusted", (Object)true, QueryFilter.FilterType.eq);
            Object object5 = arrayList2.iterator();
            while (object5.hasNext()) {
                String string5 = (String)object5.next();
                long l2 = this.count(Collections.singletonList(object32), null);
                if (l2 >= (long)com.tp_link.eap.util.e.bC.intValue()) break;
                if (!com.tp_link.eap.util.p.c.d((String)string5) || hashMap.get(string5) != null) continue;
                object2 = this.b.findByMacAndSite(string5, com.tp_link.eap.d.b.a());
                if (object2 == null) {
                    object2 = new RogueAp();
                    object2.setMac(string5);
                    object2.setChannel(null);
                    object2.setBand(null);
                    object2.setSecurity(null);
                    object2.setSsid(null);
                    object2.setSite(string2);
                }
                object2.setTrusted(true);
                object2.setBeacon(null);
                object2.setSignal(null);
                object2.setLastSeen(System.currentTimeMillis());
                this.b.save(object2);
                object = new RogueApConfig();
                object.setMac(string5);
                object.setTrust(Boolean.valueOf(true));
                arrayList3.add(object);
                hashMap.put(string5, true);
            }
            if (!CollectionUtils.isEmpty((Collection)(object5 = this.c.findBySiteAndAdopted(string2, true)))) {
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    Ap ap = (Ap)iterator.next();
                    String string6 = ap.getMac();
                    object = object2 = com.tp_link.eap.b.b.a.a((String)string6);
                    synchronized (object) {
                        EapConfigBody eapConfigBody;
                        SettingRecord settingRecord = this.d.getRecord(string6, SettingRecord.SettingStatus.PENDING);
                        if (settingRecord == null) {
                            settingRecord = this.d.getRecord(string6, SettingRecord.SettingStatus.BACKUP);
                        }
                        if (settingRecord == null) {
                            eapConfigBody = new EapConfigBody();
                            eapConfigBody.setRogueApSetting(arrayList3);
                            settingRecord = new SettingRecord(string6, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                            this.d.refreshRecord(settingRecord);
                        } else {
                            eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord.getContent(), EapConfigBody.class);
                            eapConfigBody.setRogueApSetting(arrayList3);
                            settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                            this.d.refreshRecord(settingRecord);
                        }
                    }
                }
            }
            hashMap = null;
            return com.tp_link.eap.util.e.bd;
        }
        catch (DocumentException documentException) {
            this.a.warn("failed to resolve trusted ap file.", (Throwable)documentException);
            return new OperationResponse(ResErrorCode.di);
        }
    }

    private boolean a(Element element) {
        return element.getName().equals(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(RogueApConfig rogueApConfig) {
        List<Ap> list;
        if (rogueApConfig == null) {
            this.a.warn("rogueApConfig to set is null");
        }
        if (!CollectionUtils.isEmpty(list = this.c.findBySiteAndAdopted(com.tp_link.eap.d.b.a(), true))) {
            for (Ap ap : list) {
                Object object;
                String string = ap.getMac();
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
                synchronized (object2) {
                    Object object3;
                    SettingRecord settingRecord = this.d.getRecord(string, SettingRecord.SettingStatus.PENDING);
                    if (settingRecord == null) {
                        settingRecord = this.d.getRecord(string, SettingRecord.SettingStatus.BACKUP);
                    }
                    EapConfigBody eapConfigBody = new EapConfigBody();
                    if (settingRecord == null) {
                        eapConfigBody.setRogueApSetting(Collections.singletonList(rogueApConfig));
                        object3 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                        this.d.refreshRecord((SettingRecord)object3);
                    } else {
                        eapConfigBody = (EapConfigBody)com.tp_link.eap.util.a.b.a((String)settingRecord.getContent(), EapConfigBody.class);
                        if (eapConfigBody == null) {
                            eapConfigBody = new EapConfigBody();
                            eapConfigBody.setRogueApSetting(Collections.singletonList(rogueApConfig));
                            object3 = new SettingRecord(string, com.tp_link.eap.util.a.b.a((Object)eapConfigBody), SettingRecord.SettingStatus.PENDING);
                            this.d.refreshRecord((SettingRecord)object3);
                        } else if (CollectionUtils.isEmpty((Collection)eapConfigBody.getRogueApSetting())) {
                            eapConfigBody.setRogueApSetting(Collections.singletonList(rogueApConfig));
                            settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                            this.d.refreshRecord(settingRecord);
                        } else {
                            object3 = this.a(eapConfigBody.getRogueApSetting(), rogueApConfig);
                            if (object3.isEmpty()) {
                                eapConfigBody.setRogueApSetting(null);
                            } else {
                                eapConfigBody.setRogueApSetting((List)object3);
                            }
                            settingRecord.setContent(com.tp_link.eap.util.a.b.a((Object)eapConfigBody));
                            this.d.refreshRecord(settingRecord);
                        }
                    }
                }
            }
        }
    }

    private List<RogueApConfig> a(List<RogueApConfig> list, RogueApConfig rogueApConfig) {
        boolean bl = false;
        ArrayList<RogueApConfig> arrayList = new ArrayList<RogueApConfig>(list);
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            RogueApConfig rogueApConfig2 = (RogueApConfig)arrayList.get(i2);
            if (!rogueApConfig2.getMac().equals(rogueApConfig.getMac())) continue;
            bl = true;
            if (rogueApConfig2.getTrust().equals(rogueApConfig.getTrust())) break;
            list.remove(i2);
            break;
        }
        if (!bl) {
            list.add(rogueApConfig);
        }
        return list;
    }

    @Override
    public OperationResponse delete(String rogueId) {
        if (rogueId == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        RogueAp rogueAp = (RogueAp)this.b.findOne((Serializable)((Object)rogueId));
        if (rogueAp == null) {
            return new OperationResponse(ResErrorCode.cV);
        }
        this.b.delete(rogueAp);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse deleteThreadSiteAll(boolean isTrust) {
        List<RogueAp> list = this.b.findByIsTrustedAndSite(isTrust, com.tp_link.eap.d.b.a());
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResponse getGridRogues(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)com.tp_link.eap.util.a.b.a((Object)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        Boolean bl = (Boolean)queryData.getFilters().get("isTrusted");
        if (bl != null) {
            if (bl.booleanValue()) {
                grid.initFilters("isTrusted", (Object)true, QueryFilter.FilterType.eq);
            } else {
                grid.initFilters("isTrusted", (Object)false, QueryFilter.FilterType.eq);
            }
        }
        grid.initSearch(queryData.getSearchKey(), new String[]{"ssid", "mac", "apMac"});
        long l2 = this.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(new ArrayList(list));
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse rogueClear(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Boolean bl = jSONObject.optBoolean("isTrust");
        return this.deleteThreadSiteAll(bl);
    }

    @Override
    public void rogueExport(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        try {
            ServletOutputStream servletOutputStream = response.getOutputStream();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = simpleDateFormat.format(System.currentTimeMillis());
            string = string.replace(":", "-");
            string = string.replace(" ", "_");
            String string2 = "Trusted_Ap_List(" + string + ").cfg";
            response.reset();
            response.setCharacterEncoding("utf-8");
            response.setHeader("Cache-Control", "max-age:3");
            response.setHeader("Content-Disposition", "attachment;fileName=" + new String(string2.getBytes("UTF-8"), "UTF-8"));
            this.exportTrustList((OutputStream)servletOutputStream);
        }
        catch (IOException iOException) {
            this.a.warn("exception .", (Throwable)iOException);
        }
    }

    @Override
    public OperationResponse rogueExport(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String string = simpleDateFormat.format(System.currentTimeMillis());
            string = string.replace(":", "-");
            string = string.replace(" ", "_");
            String string2 = "Trusted_Ap_List(" + string + ").cfg";
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.exportTrustList(byteArrayOutputStream);
            byte[] byArray = Base64.getEncoder().encode(byteArrayOutputStream.toByteArray());
            ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray);
            DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
            defaultFullHttpResponse.headers().set((CharSequence)"X-Transfer-Id", (Object)transferId);
            defaultFullHttpResponse.headers().set((CharSequence)"Encode", (Object)"base64");
            defaultFullHttpResponse.headers().set((CharSequence)"Content-Disposition", (Object)("attachment;fileName=" + new String(string2.getBytes("UTF-8"), "UTF-8")));
            defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)byArray.length);
            com.tp_link.eap.monitor.cloud.proxy.a.a.a(ctx, defaultFullHttpResponse);
            return com.tp_link.eap.util.e.bd;
        }
        catch (IOException iOException) {
            this.a.warn("exception .", (Throwable)iOException);
            return com.tp_link.eap.util.e.aY;
        }
    }

    @Override
    public OperationResponse rogueImport(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) throws Exception {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("importMode");
        response.setCharacterEncoding("UTF-8");
        if (n2 < 0 || n2 > 1) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = new String(com.tp_link.eap.util.g.a.a((HttpServletRequest)request));
        return this.importTrustList(string, n2 == 0);
    }

    @Override
    public OperationResponse rogueImport(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("importMode");
        if (n2 < 0 || n2 > 1) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = new String(fileContent);
        return this.importTrustList(string, n2 == 0);
    }

    @Override
    public OperationResponse rogueDelete(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("rogueId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.delete(string);
    }

    private void a() {
        if (l.b()) {
            return;
        }
        long l2 = this.b.count();
        while (l2 != 0L && l2 >= 16000L) {
            this.a.info("Rogue AP {} reached maximum", (Object)l2);
            this.b.clearUntrustedTop(1000, "lastSeen");
            l2 = this.b.count();
            this.a.info("after clear num is {}", (Object)l2);
        }
    }
}

